;*******************************************************************************
;***************** 122 GHz tranceiver CONTROL PROGRAM VER # 19F2704 ************
;*******************************************************************************
;******************************** VK3CV / WQ1S *********************************
;*******************************************************************************
;
; SYNTH FREQUENCY DATA IS STORED IN EEPROM , STARTING AT LOCATION 000H
; LS BYTE OF FREQUENCY DATA MUST ALL BE IN THE SAME PAGE
;
;**************************** 10MHz EXTERNAL CLOCK *****************************
;
;
		list p=16F877A
;
		include "P16F877A.inc"
;
		ERRORLEVEL 0, -302	;SUPPRESS SFR PAGE SELECT WARNINGS 
;
		__CONFIG 0373AH

; ICD debugger reserved resources
;
; Program memory 01F00H - 01FFFH
;
; RAM GP registers 070H, 0F0H, 0170H, 01E5H - 01F0H  
;
;
;	DEFINITIONS
;				
GR1		EQU	071H		;GL0BAL REGISTERS (EXIST IN ALL BANKS)
GR2		EQU	072H
GR3		EQU	073H
GR4		EQU	074H
GR5		EQU	075H
EEPOINT		EQU	076H		;GLOBAL EEPOINT REGISTER
GFLAG		EQU	077H		;GLOBAL FLAG REGISTER
W_TEMP		EQU	078H
STATUS_TEMP	EQU	079H
PCLATH_TEMP	EQU	07AH
;
;
;GFLAG GLOBAL FLAG DEFINITIONS
TXON		EQU	000H		;0 = NO TX, 1 = TX IS ACTIVE
CWON		EQU	001H		;0 = NO CW KEY, 1 = CW KEY
RXSTAT		EQU	002H		;0 = NOT IN RX STATE , 1 = IN RX STATE
GPS		EQU	003H		;0 = NO GPS DICIPLINING , 1 = GPS ACTIVE
CURS		EQU	004H		;CURSOR TOGGLE FLAG
;BIT5
;BIT6
;BIT7
;
;
R0		EQU	020H		;RAM GENERAL REGISTERS ALL IN BANK 0
R1		EQU	021H
R2		EQU	022H
R3		EQU	023H
R4		EQU	024H
R5		EQU	025H
R6		EQU	026H
R7		EQU	027H
R8		EQU     028H
TEMP		EQU	029H
;
;********** RAM REGISTERS *********** (ALL IN BANK O)
;
COUNT		EQU	02AH		;GENERAL PURPOSE COUNT
SWITCH		EQU	02BH		;CURRENT SWITCH SETTING (CHANNEL NUMBER)
LSWITCH		EQU	02CH		;LAST SWITCH SETTING
REFHV		EQU	02DH		;10MHz REFERANCE DC VOLTAGE HIGH BITS
REFLV		EQU	02EH		;10MHz REFERANCE DC VOLTAGE LOW BITS
VCOHV	 	EQU	02FH		;VCO VOLTAGE HIGH BITS
VCOLV		EQU	030H		;VCO VOLTAGE LOW BITS
DCINHV		EQU	031H		;DC INPUT VOLTAGE HIGH BYTE
DCINLV		EQU	032H		;DC INPUT VOLTAGE LOW BYTE
MORSECH		EQU	033H		;CURRENT MORSE CHARACTER
MORSE1		EQU	034H		;MORSE REGISTER 1
MORSE2		EQU	035H		;MORSE REGISTER 2
MORSE3		EQU	036H		;MORSE REGISTER 3
SYNTHP		EQU	037H		;SYNTHESIZER EEPROM DATA POINTER
TXOPT		EQU	038H		;CURRENT CHANNEL TX OPTION BYTE
RXOPT		EQU	039H		;CURRENT CHANNEL RX OPTION BYTE
RTUNE		EQU	03AH		;REFERANCE TUNE REGISTER 8 BITS (EEPROM ERTUNE VALUE)
RERROR		EQU	03BH		;REFERANCE ERROR VALUE (CCPR1L VALUE AT INTERRUPT)
LASTRERROR	EQU	03CH		;LAST REF ERROR VALUE
NERCOUNT	EQU	03DH		;NO ERROR REF COUNT 
LOOPC		EQU	03EH		;MAIN LOOP COUNTER
;
;
;END OF RAM IS 05FH IN BANK 0 , 060H - 07FH EXISTS IN ALL BANKS (GLOBAL REGS)
;
;
;** FIXED EQUATES **
;
;
DCTHRESH	EQU	0F0H		;DC INPUT ALARM THRESHOLD
;
;************************* COLD BOOT PROGRAM START ****************************
;
;START AT THE RESET VECTOR
		ORG	000H
		NOP
		GOTO	COLD
;
;****************************** INTERRUPT VECTOR ******************************
;INTERRUPT VECTORS TO HERE
;
		ORG	004H
		GOTO	INTSERV		;SERVICE INTERRUPTS
;
;******************************** START OF PROGRAM ****************************
;
COLD		ORG	020H		;START ADDRESS
		NOP
;
;	PORT INITIALIZATION
;
;	PORT A
;
VDC		EQU	000H		;AN0 INPUT ANALOG DC INPUT VOLTAGE 
VCXOTUNE	EQU	001H		;AN1 INPUT ANALOG VCTCXO TUNE VOLTAGE
GPSRXD		EQU	002H		;OUTPUT DIGITAL GPS RXD
VPLL		EQU	003H		;AN3 INPUT ANALOG PLL VCO ERROR VOLTAGE 
KEYIN		EQU	004H		;INPUT DIGITAL KEY LINE INPUT
RXEN		EQU	005H		;OUTPUT DIGITAL RF CHIP RX ENABLE
;
		BANKSEL	0
       		CLRF	PORTA		;INITIALIZE PORTS AND DIRECTIONS
;
		MOVLW	089H		;SET UP AD INPUT HERE
		MOVWF	ADCON0		;OSC/32 , AN1 SELECTED
;
		BANKSEL	ADCON1
		MOVLW	004H		;LEFT JUSTIFIED, 3 x ANALOGUE IN , REF VDD & VSS
		MOVWF	ADCON1
;
		MOVLW	B'11011011'	;PORT A DIRECTIONS 
		MOVWF	TRISA		
		BANKSEL	0		;BACK TO REGISTER BANK 0
		MOVLW	B'00000000'     ;PORT A LEVELS
		MOVWF	PORTA		;SET UP INITIAL PORT A LEVELS	
;
;	PORT B
;
GPSTXD		EQU	000H		;INPUT DIGITAL GPS TX DATA
SW1		EQU	001H		;INPUT DIGITAL SWITCH 1
SW2		EQU	002H		;INPUT DIGITAL SWITCH 2
SW4		EQU	003H		;INPUT DIGITAL SWITCH 4
SW8		EQU	004H		;INPUT DIGITAL SWITCH 8
VMIC		EQU	005H		;OUTPUT DIGITAL MIC AMP ENABLE
;ICD		EQU	006H		;RESERVED FOR ICD
;ICD		EQU	007H		;RESERVED FOR ICD
;
		CLRF	PORTB
		BANKSEL	TRISB
		MOVLW	B'11011111'     ;PORT B DIRECTIONS
		MOVWF	TRISB		
		BCF	OPTION_REG,7	;ENABLE PORT B WEAK PULLUPS
       		BANKSEL	0
		MOVLW	B'00000000'     ;PORT B INITIAL LEVELS
		MOVWF	PORTB		
;
;	PORT C	
;
RFLE		EQU	000H		;OUTPUT DIGITAL PLL SPI CHIP LATCH ENABLE
PWM		EQU	001H		;OUTPUT DIGITAL PWM REF STEERING
PPS		EQU	002H		;INPUT DIGITAL 1PPS
RFCLK		EQU	003H		;OUTPUT DIGITAL PLL SPI CLOCK (LED1)
RFMUX		EQU	004H		;INPUT DIGITAL PLL MUX
RFDATA		EQU	005H		;OUTPUT DIGITAL PLL SPI DATA (LED2)
TXD		EQU	006H		;OUTPUT RS232 TX DATA
RXD		EQU	007H		;INPUT RS232 RX DATA
;
;
 		CLRF	PORTC
		BANKSEL	TRISC
		MOVLW	B'10010100'     ;PORT C DIRECTIONS 
		MOVWF	TRISC		
       	 	BANKSEL	0
		MOVLW	B'00001000'     ;PORT C INITIAL LEVELS (LED ON)
		MOVWF	PORTC		
;
;	PORT D
;
VT1		EQU	000H		;OUTPUT DIGITAL RF TUNE 1
VT2		EQU	001H		;OUTPUT DIGITAL RF TUNE 2
VT3		EQU	002H		;OUTPUT DIGITAL RF TUNE 3
FSK		EQU	003H		;OUTPUT DIGITAL FSK 
PTTIN		EQU	004H		;INPUT DIGITAL PTT INPUT
PTTOUT		EQU	005H		;OUTPUT DIGITAL PTT OUTPUT
SIDETONE	EQU	006H		;OUTPUT DIGITAL AUDIO SIDETONE
KEYOUT		EQU	007H		;OUTPUT DIGITAL KEY OUT
;
		CLRF	PORTD
		BANKSEL	TRISD
		MOVLW	B'00011000'	;PORT D DIRECTIONS 
       	 	MOVWF	TRISD
		BANKSEL	0
		MOVLW	B'00000011'	;PORT D INITIAL LEVELS (VCO STEER LINES)
		MOVWF	PORTD
;
;	PORT E
;
STEER0		EQU	000H		;OUTPUT/HIZ DIGITAL REF STEER 0
STEER1		EQU	001H    	;OUTPUT/HIZ DIGITAL REF STEER 1
STEER2		EQU	002H    	;OUTPUT/HIZ DIGITAL REF STEER 2
;
		CLRF	PORTE
		BANKSEL	TRISE
		MOVLW	B'00000000'	;PORT E DIRECTIONS
		MOVWF	TRISE           
		BANKSEL	0
		MOVLW	B'00000011'	;PORT E INITIAL LEVELS
		MOVWF	PORTE
;
;
;	COMMS PORT CONFIG
;
		BANKSEL	TXSTA
		MOVLW	B'00100110'	;TX MODE: 8 BITS, ASYNC, HIGH SPEED
		MOVWF	TXSTA		;SET MODE
		BANKSEL	RCSTA
		MOVLW	B'10010000'	;RX MODE 8 BITS, ASYNC, RX ENABLED
		MOVWF	RCSTA		;SET MODE
		MOVLW	D'64'		;SET BAUD RATE 	9600 Bd D64
					;	       56000 Bd D10
		BANKSEL	SPBRG
		MOVWF	SPBRG		;LOAD BAUD RATE
;
;
;	TIMER 2 SET UP AS SOURCE FOR PWM
;
		BANKSEL	PR2
		MOVLW	0FFH		;(0FFH)TIMER 2 LOAD VALUE
		MOVWF	PR2
		BANKSEL	T2CON
		MOVLW	B'00000110'	;1/16 PRE SCALE OR POST SCALE, RUN TIMER 2
		MOVWF	T2CON		;UPDATE 610Hz
		BANKSEL	0
;
;
;	PWM REFERANCE AND STEERING OUTPUT CONFIG
;
VREFSET		CALL	SETREF		;SET INITIAL PWM REFERANCE CONTROL VALUES TO EEPROM STORED VALUES
;					;STEER LINES ALSO UPDATED IF REQUIRED
		MOVLW	010H
		MOVWF	LASTRERROR	;INITIALIZE LAST ERROR VALUE TO DUMMY MID RANGE
		MOVLW	0FFH
		MOVWF	NERCOUNT	;INITIALIZE NO ERROR COUNT
;
;	TIMER 1 SET UP FOR 1PPS CAPTURE WITH INTERRUPTS
;
		MOVLW	B'00000001'	;SET UP TIMER 1, NO PRE SCALE, Fosc/4, ENABLE TIMER 1
		BANKSEL	T1CON
		MOVWF	T1CON
;
		BANKSEL	CCP1CON
		MOVLW	B'00000100'	;SET UP CAPTURE COMPARE 1 INPUT, FALLING EDGE, SOURCE TIMER 1
		MOVWF	CCP1CON				
		BANKSEL	0
;
;
;******************** START OF MAIN PROGRAM *************************
START		NOP
		CLRF	GFLAG		;CLEAR FLAG REGISTER, NO TX , NO CW KEY, NO RX STATE
		CLRF	LOOPC		;CLEAR LOOP COUNTER
		CALL	LEDRED
		CALL	WAITONE
		CALL	PRBOOT		;PRINT BOOT UP STRING
		CALL	WAITONE
;
		CALL	LBEEP
		CALL	SYNTHRX		;INITIALIZE SYTHESIZER CHIP
;
		BANKSEL	PIR1		;CLEAR CCP1 INTERRUPT FLAG AND ENABLE INTERRUPTS
		BCF	PIR1,CCP1IF
		BANKSEL	PIE1
		BSF	PIE1,CCP1IE	;ENABLE CCP1 INT
		BANKSEL	0
		BSF	INTCON,PEIE	;ENABLE PERIPHERAL INTERRUPTS
		BSF	INTCON,GIE	;ALL GOOD TO GO
;
;
;************************** MAIN PROGRAM LOOP *********************************
;
MAIN		INCF	LOOPC,F		;INCREMENT MAIN LOOP COUNTER EACH TIME 
		BTFSS	PORTC,RFMUX	;CHECK IF PLL LOCKED		
		CALL	PLLERR
		BTFSS	PORTD,PTTIN	;CHECK IF TX REQUESTED
		GOTO	MAYBTXAU
		BTFSS	PORTA,KEYIN	;CHECK IF CW REQUESTED
		GOTO	CWKEY		;MUST BE CW TX
;
RXACTIVE	BTFSS	GFLAG,RXSTAT	;CHECK IF FIRST TIME THROUGH
		CALL	SYNTHRX		;PROGRAM SYNTH IF FIRST TIME HERE
		CALL	LEDGRN		;PUT GREEN LED ON
		BSF	GFLAG,RXSTAT	;SHOW RX STATE
		BCF	GFLAG,TXON	;NO TX ACTIVITY SO CLEAR FLAGS
		BCF	GFLAG,CWON
		BCF	PORTD,PTTOUT	;RESET OUTPUT LINES
		BCF	PORTD,KEYOUT
		BCF	PORTB,VMIC	;TURN OFF MIC AMP
		BCF	PORTB,VMIC
		BCF	PORTA,RXEN	;ENABLE RX
		GOTO	CHKCH		;CONTINUE LOOP
;
MAYBTXAU	BCF	GFLAG,RXSTAT	;SHOW NOT IN RX STATE
		BTFSS	PORTA,KEYIN	;MAYBE AUDIO SO CHECK IF KEY ALSO
		GOTO	BEACONFM	;BOTH SO BEACON MODE
;
;TX FM AUDIO MODE
;
		BCF	GFLAG,CWON	;AUDIO TX STATE SO CLEAR CW FLAG	
		BCF	GFLAG,RXSTAT	;SHOW NOT RX STATE
		BCF	PORTA,RXEN	;ALWAYS ENABLE RX
		BTFSC	GFLAG,TXON	;CHECK IF FIRST TIME		
		GOTO	TXSLOP		;TX ALREADY ON SO CONTINUE
		BSF	GFLAG,TXON	;FIRST TIME THROUGH SO PROG SYNTH
		CALL	SYNTHRX
;
TXSLOP		BSF	PORTD,PTTOUT	;ASSERT PTT OUTPUT
		BSF	PORTB,VMIC	;TURN ON MIC AMP
		BSF	PORTB,VMIC
		CALL	LEDRED		;PUT RED LED ON
		GOTO	CHKCH		;CONTINUE LOOP
;
BEACONFM	BTFSC	PORTB,SW1	;CHECK IF CW BEACON OR FM BEACON MODE
		GOTO	BEACONCW	;DETERMINED BY STATE OF A/B CHANNEL SWITCH
		BCF	PORTB,VMIC
		BCF	PORTB,VMIC	;MAKE SURE MIC IS OFF
		CALL	MORSEIDENT	;SEND MORSE IDENT
		CALL	LEDRED
		CALL	WAIT
		CALL	GETDC		;CHECK DC EVERY LOOP IN THIS MODE
		CALL	CARRIER		;SEND CARRIER BETWEEN IDENTS (JUST A LONG DELAY)
;
		CALL	GETREF		;GET REFERANCE TUNE VOLTAGE
		CALL	GETVCO		;GET VCO TUNE VOLTAGE
		BTFSC	PORTC,7		;CHECK IF RS232 IS CONNECTED
		CALL	PRINTSTAT	;YES SO PRINT STATUS EVERY LOOP
		GOTO	CHKCH		;CONTINUE LOOP
;
BEACONCW	BCF	PORTB,VMIC
		BCF	PORTB,VMIC	;MAKE SURE MIC IS OFF
		CALL	MORSEIDENT	;SEND CW MORSE IDENT
		CALL	WAIT
		CALL	GETDC		;CHECK DC EVERY LOOP IN THIS MODE
		CALL	SYNTHTX		;PUT ON CW CARRIER
		CALL	LEDRED
		CALL	CARRIER		;SEND CARRIER BETWEEN IDENTS (JUST A LONG DELAY)
		CALL	SYNTHRX		;BACK TO RX AFTER CARRIER
		CALL	LEDGRN
		CALL	WAIT
		CALL	WAIT		;SMALL SPACE BEFORE NEXT IDENT 
;
		CALL	GETREF		;GET REFERANCE TUNE VOLTAGE
		CALL	GETVCO		;GET VCO TUNE VOLTAGE
		BTFSC	PORTC,7		;CHECK IF RS232 IS CONNECTED
		CALL	PRINTSTAT	;YES SO PRINT STATUS EVERY LOOP
		GOTO	CHKCH		;CONTINUE LOOP
;
CWKEY		BCF	GFLAG,RXSTAT	;SHOW NOT IN RX STATE
		BCF	GFLAG,TXON	;CW STATE SO CLEAR TX FLAG 
		BCF	GFLAG,RXSTAT	;SHOW NOT RX STATE
		BCF	PORTA,RXEN	;ALWAYS ENABLE RX
;
		BTFSC	PORTB,SW1	;CHECK IF CW OR FM MODE REQUIRED
		GOTO	CWKEYCAR	;GOTO CW CARRIER ONLY MODE

		BTFSC	GFLAG,CWON	;CHECK IF FIRST TIME
		GOTO	CWLOP
		BSF	GFLAG,CWON	;FIRST TIME THROUGH SO PROG SYNTH
		BANKSEL	TRISD
		BCF	TRISD,FSK
		BCF	TRISD,SIDETONE	;LOW Z FSK AND SIDETONE
		BANKSEL	0
		CALL	SYNTHRX		;STAY ON RX FREQ IN THIS MODE
;
CWLOP		BSF	PORTD,KEYOUT	;ASSERT KEY OUTPUT
		CALL	LEDRED
		BTFSS	PORTD,FSK	;TOGGLE FSK AND SIDETONE TO GENERATE CW AUDIO
		GOTO	CWLOPT	
		BCF	PORTD,FSK
		BCF	PORTD,SIDETONE
		GOTO	CWLT
CWLOPT		BSF	PORTD,FSK
		BSF	PORTD,SIDETONE
;
CWLT		BTFSC	PORTA,KEYIN	;CHECK IF STILL KEYED
		GOTO	ENDCW		;STAY IN LOOP UNTIL RELEASED
		BTFSS	PORTD,PTTIN	;CHECK THAT PTT IS NOT ASSERTED
		GOTO	ENDCW		;PTT ASSERTED SO BEACON MODE IS REQUESTED
		CALL	CWTDEL		;CW TONE DELAY ROUTINE	
		GOTO	CWLOP
;
ENDCW		NOP
		BANKSEL	TRISD
		BSF	TRISD,FSK
		BSF	TRISD,SIDETONE	;HI Z FSK AND SIDETONE
		BANKSEL	0
		GOTO	CHKCH
;
CWKEYCAR	BTFSC	GFLAG,CWON	;CHECK IF FIRST TIME
		GOTO	CWLOPCAR
		BSF	GFLAG,CWON	;FIRST TIME THROUGH SO PROG SYNTH
		BANKSEL	TRISD
		BCF	TRISD,SIDETONE	;LOW Z SIDETONE
		BANKSEL	0
		CALL	SYNTHTX		;STAY ON RX FREQ IN THIS MODE
;
CWLOPCAR	BSF	PORTD,KEYOUT	;ASSERT KEY OUTPUT
		CALL	LEDRED
		BTFSS	PORTD,SIDETONE	;TOGGLE SIDETONE TO GENERATE CW AUDIO
		GOTO	CWLOPTCAR	
		BCF	PORTD,SIDETONE
		GOTO	CWLTCAR
CWLOPTCAR	BSF	PORTD,SIDETONE
;
CWLTCAR		BTFSC	PORTA,KEYIN	;CHECK IF STILL KEYED
		GOTO	ENDCWCAR	;STAY IN LOOP UNTIL RELEASED
		BTFSS	PORTD,PTTIN	;CHECK THAT PTT IS NOT ASSERTED
		GOTO	ENDCWCAR	;PTT ASSERTED SO BEACON MODE IS REQUESTED
		CALL	CWTDEL		;CW TONE DELAY ROUTINE	
		GOTO	CWLOPCAR
;
ENDCWCAR	NOP
		BANKSEL	TRISD
		BSF	TRISD,FSK
		BSF	TRISD,SIDETONE	;HI Z FSK AND SIDETONE
		BANKSEL	0
;
CHKCH		CALL	GETSWITCH	;CHECK SWITCH AND CONTINUE LOOP
		MOVFW	LSWITCH
		SUBWF	SWITCH,W
		BTFSC	STATUS,Z	;CHECK FOR CHANNEL CHANGE
		GOTO	NOCH	
		MOVFW	SWITCH
		MOVWF	LSWITCH		;UPDATE LAST SWITCH
		CALL	SYNTHRX		;UPDATE SYNTHESIZER
		CLRF	GFLAG		;CLEAR STATE FLAG TO UPDATE LEDS ETC
;
NOCH		MOVFW	LOOPC		;GET LOOP COUNTER
		ANDLW	B'01111111'	;MASK TO SET RATE
		BTFSS	STATUS,Z
		GOTO	EVERYL		;GET DC EVERY N LOOPS				
		CALL	GETDC
;
EVERYL		CALL	GETREF		;GET REFERANCE TUNE VOLTAGE
		NOP
		CALL	GETVCO		;GET VCO TUNE VOLTAGE
;
		MOVFW	LOOPC
		BTFSS	STATUS,Z	;PRINT STATUS EVERY 256 TIMES THROUGH MAIN LOOP
		GOTO	MAIN
;
		BTFSC	PORTC,7		;CHECK IF RS232 IS CONNECTED
		CALL	PRINTSTAT	;YES SO PRINT STATUS
		GOTO	MAIN
;
;********************************** READ SWITCH *******************************
;
GETSWITCH	RRF	PORTB,W
		MOVWF	SWITCH
		COMF	SWITCH,W
		ANDLW	B'00001111'	;MASK OFF UNUSED BITS
		MOVWF	SWITCH
		RETURN
;
;
;*********************************** LED CONTROL ******************************
;
;LED TO RED
;
LEDRED		BSF	PORTC,3
		BSF	PORTC,3
		BCF	PORTC,5
		BCF	PORTC,5
		RETURN
;
;LED TO GREEN
;
LEDGRN		BCF	PORTC,3
		BCF	PORTC,3
		BSF	PORTC,5
		BSF	PORTC,5
		RETURN
;
;LED OFF
;
LEDOFF		BCF	PORTC,3
		BCF	PORTC,3
		BCF	PORTC,5
		BCF	PORTC,5
		RETURN
;
;***************************** SYNTHESIZER ROUTINES ***************************
;
;PROGRAM SYNTHESIZER
;
SYNTHTX		CALL	SYNTHRL		;SEND R0,R1,R2 TO SYNTH
		MOVLW	004H
		ADDWF	SYNTHP,F	;ADD TX OFFSET	
		CALL	SYNTHREG	;SEND (R3) TX FREQ DATA TO SYNTH , ALSO INCREMENTS TO NEXT POINTER LOCATION	
		MOVFW	SYNTHP		;GET TX OPTION BYTE
		CALL	READEE		;W CONTAINS EEPROM READ ADDRESS ON CALL AND DATA CONTENTS ON RETURN
		MOVWF	TXOPT
		RETURN
;
SYNTHRX		CALL	SYNTHRL		;SEND R0,R1,R2 TO SYNTH
		CALL	SYNTHREG	;SEND (R3) RX FREQ DATA TO SYNTH , ALSO INCREMENTS TO NEXT POINTER LOCATION
		MOVFW	SYNTHP		;GET RX OPTION BYTE
		CALL	READEE		;W CONTAINS EEPROM READ ADDRESS ON CALL AND DATA CONTENTS ON RETURN
		MOVWF	RXOPT
		RETURN
;
;LOAD FIRST 3 SYNTH REGISTERS
;
SYNTHRL		MOVLW	LOW SYNTHINIT	;POINT TO START OF SYNTH DATA TABLE
		MOVWF	SYNTHP		;LOAD POINTER
		CALL	SYNTHREG	;LOAD FIRST REGISTER (R0)
		CALL	SYNTHREG	;LOAD SECOND REGISTER (R1)
		CALL	SYNTHREG	;LOAD THIRD REGISTER (R2)
;		
		MOVLW	LOW FREQ0R	;POINT TO START OF FREQUENCY TABLE DATA 
		MOVWF	SYNTHP		;LOAD POINTER
;
		MOVFW	SWITCH		;GET CHANNEL NUMBER
		MOVWF	R0		;SWITCH TEMP STORE
		BCF	STATUS,C
		RLF	R0,F		;MULTIPLY X 8 TO GET CHANNEL OFFSET
		BCF	STATUS,C
		RLF	R0,F
		BCF	STATUS,C
		RLF	R0,F
		BCF	STATUS,C
		MOVFW	R0
		ADDWF	SYNTHP,F	;UPDATE POINTER TO CORRECT TABLE POSITION
		RETURN
;
;POWER DOWN SYNTH AND RESET
;
SYNTHOFF	MOVLW	LOW SYNTHDIS	;POINT TO START OF SYNTH DISSABLE TABLE
		MOVWF	SYNTHP		;LOAD POINTER
		CALL	SYNTHREG	;LOAD FIRST REGISTER (R0)
		CALL	SYNTHREG	;LOAD SECOND REGISTER (R1)
		CALL	SYNTHREG	;LOAD THIRD REGISTER (R2)
		CALL	SYNTHREG	;LOAD FOURTH REGISTER (R3)	
		RETURN
;
;SEND SYNTH DATA TO CHIP
;
SYNTHREG	MOVLW	003H		;LOAD EACH SYTHESIZER REGISTER IN TURN WITH 3 BYTES
		MOVWF	R0		;LOAD COUNTER WITH FIRST 6 BYTES OF SYNTH DATA (ALWAYS COMMON)	
		BCF	PORTC,RFLE	;SYNTH LATCH ENABLE LOW TO START	
		BCF	PORTC,RFCLK	;SYNTH CLOCK LOW
		BCF	PORTC,RFCLK	;SYNTH CLOCK LOW
		BCF	PORTC,RFDATA	;SYNTH DATA LOW
		BCF	PORTC,RFDATA	;SYNTH DATA LOW
SYNTHLOP	MOVFW	SYNTHP
		CALL	READEE		;W CONTAINS EEPROM READ ADDRESS ON CALL AND DATA CONTENTS ON RETURN
		CALL	SYNTHSEND	;SEND DATA TO SYNTH
		INCF	SYNTHP,F	;GOTO NEXT EEPROM LOCATION
		DECF	R0,F
		BTFSS	STATUS,Z
		GOTO	SYNTHLOP
		BSF	PORTC,RFLE	;LATCH DATA INTO CHIP
		RETURN
;
SYNTHSEND	MOVWF	R2		;SAVE DATA
		MOVLW	08H		;8 DATA BITS TO SEND
		MOVWF	R1
SYNSELOP	BTFSS	R2,7
		GOTO	SYNDATL
		BSF	PORTC,RFDATA	;SET UP DATA LINE
		BSF	PORTC,RFDATA	;SET UP DATA LINE
		GOTO	SYNDATSE
SYNDATL		BCF	PORTC,RFDATA
		BCF	PORTC,RFDATA
SYNDATSE	NOP
		BSF	PORTC,RFCLK
		BSF	PORTC,RFCLK	;SYNTH CLOCK HIGH
		NOP
		BCF	PORTC,RFCLK	;TOGGLE CLOCK
		BCF	PORTC,RFCLK	;SYNTH CLOCK LOW
		BCF	STATUS,C
		RLF	R2,F		;POINT TO NEXT BIT
		DECF	R1,F
		BTFSS	STATUS,Z
		GOTO	SYNSELOP
		RETURN
;
PLLERR		CALL	SYNTHOFF	;PUT SYNTH OFF
		CALL	LEDRED
		CALL	LBEEP
;
		CALL	LEDOFF
;
		CALL	GETREF		;KEEP VOLTAGES UPDATED IF IN PLL ERROR
		CALL	GETVCO
;
		BTFSC	PORTC,7		;CHECK IF RS232 IS CONNECTED
		CALL	PRINTSTAT	;YES SO PRINT STATUS
;		
		CALL	SYNTHRX		;RE-INITIALIZE SYNTH
		CALL	LBEEP
		CALL	LEDGRN		;SHOW GREEN TO INDICATE FAULT MAYBE CLEARED
		RETURN
;
;************************* ADC CONVERTOR ROUTINES *****************************
;
;** GET DC INPUT
;
GETDC		MOVLW	B'10000101'	;SET UP A/D INPUT HERE
		BANKSEL	0
		MOVWF	ADCON0		;OSC/32 , AN0 SELECTED
;
		BSF	STATUS,RP0	;BANK 1
		MOVLW	084H		;RIGHT JUSTIFIED , 3 ANALOGUE IN , REF VDD & VSS
		MOVWF	ADCON1
		BCF	STATUS,RP0	;BANK 0
;
		CALL	ADCWAIT		;WAIT ROUTINE FOR ADC INPUT SETTLE
		BSF	ADCON0,2	;START CONVERSION
;
DCIL		BTFSC	ADCON0,2
		GOTO	DCIL		;LOOP TILL CONVERSION DONE
		MOVFW	ADRESH
		MOVWF	DCINHV		;PUT HIGH RESULT IN REGISTER
		BSF	STATUS,RP0	;BANK1
		MOVFW	ADRESL
		BCF	STATUS,RP0	;BANK0
		MOVWF	DCINLV		;PUT LOW RESULT IN REGISTER
;		
		MOVFW	DCINHV		;LOOK AT HIGH RESULT ONLY
		BTFSS	STATUS,Z
		RETURN			;COMPARE TO THRESHOLD
		CALL	LEDRED
		CALL	LBEEP		;ALARM IF TOO LOW
		RETURN
;
;** GET VCO ERROR VOLTAGE
;
GETVCO		MOVLW	B'10011101'	;SET UP A/D INPUT HERE
		BANKSEL	0
		MOVWF	ADCON0		;OSC/32 , AN3 SELECTED
;
		BSF	STATUS,RP0	;BANK 1
		MOVLW	084H		;RIGHT JUSTIFIED , 3 ANALOGUE IN , REF VDD & VSS
		MOVWF	ADCON1
		BCF	STATUS,RP0	;BANK 0
;
		CALL	ADCWAIT		;WAIT ROUTINE FOR ADC INPUT SETTLE
		BSF	ADCON0,2	;START CONVERSION
;
VCOIL		BTFSC	ADCON0,2
		GOTO	VCOIL		;LOOP TILL CONVERSION DONE
		MOVFW	ADRESH
		MOVWF	VCOHV		;PUT HIGH RESULT IN REGISTER
		BSF	STATUS,RP0	;BANK1
		MOVFW	ADRESL
		BCF	STATUS,RP0	;BANK0
		MOVWF	VCOLV		;PUT LOW RESULT IN REGISTER
		RETURN
;
;** GET 10MHz REFERANCE TUNE VOLTAGE
;
GETREF		MOVLW	B'10001101'	;SET UP A/D INPUT HERE
		BANKSEL	0
		MOVWF	ADCON0		;OSC/32 , AN1 SELECTED
;
		BSF	STATUS,RP0	;BANK 1
		MOVLW	084H		;RIGHT JUSTIFIED , 3 ANALOGUE IN , REF VDD & VSS
		MOVWF	ADCON1
		BCF	STATUS,RP0	;BANK 0
;
		CALL	ADCWAIT		;WAIT ROUTINE FOR ADC INPUT SETTLE
		BSF	ADCON0,2	;START CONVERSION
;
REFIL		BTFSC	ADCON0,2
		GOTO	REFIL		;LOOP TILL CONVERSION DONE
		MOVFW	ADRESH
		MOVWF	REFHV		;PUT HIGH RESULT IN REGISTER
		BSF	STATUS,RP0	;BANK1
		MOVFW	ADRESL
		BCF	STATUS,RP0	;BANK0
		MOVWF	REFLV		;PUT LOW RESULT IN REGISTER
		RETURN
;
;
; **PWM DC REFERANCE FREQUENCY CONTROL ROUTINE
;
;   10 BITS AVAILABE, TOP 2 BITS FIXED B'10' , LOWER 8 BITS STORED IN RTUNE
;   STEER LINES ALSO UPDATED FROM EEPROM STORED VALUE	 
;
SETREF		MOVLW	LOW ERTUNE	;POINT TO EEPROM RTUNE VALUE
		CALL	READEE		;GET LAST EEPROM RTUNE VALUE
		MOVWF	RTUNE		;STORE VALUE		
		ANDLW	B'00000011'	;MASK OFF UNWANTED BITS
		MOVWF	TEMP		;TEMP STORE
		BCF	STATUS,C	;CLEAR CARRY
		RRF	TEMP,F
		RRF	TEMP,F
		RRF	TEMP,F
		RRF	TEMP,F		;PUT BITS INTO CORRECT POSITIONS
		BSF	TEMP,3
		BSF	TEMP,2		;SET CONFIG BITS REQUIRED FOR CCP2CON MODE
		MOVFW	TEMP
		BANKSEL	CCP2CON
		MOVWF	CCP2CON		;SET VALUE OF PWM LSB'S (RTUNE) AND SET PWM MODE
		BANKSEL	0
		MOVFW	RTUNE		;GET RTUNE VALUE
		MOVWF	TEMP		;TEMP STORE
		BCF	STATUS,C	;CLEAR CARRY
		RRF	TEMP,F
		RRF	TEMP,F		;PUT BITS INTO CORRECT LOCATIONS
		BSF	TEMP,7
		BCF	TEMP,6		;TOP BITS ALWAYS B'10'
		MOVFW	TEMP
		BANKSEL	CCPR2L
		MOVWF	CCPR2L		;UPPER BITS OF PWM (RTUNE)(ONLY LOWER 6 BITS USED)
		BANKSEL	0
;
		MOVLW	LOW ERSTEER	;POINT TO STEER LINE EEPROM LOCATION
		CALL	READEE		;GET VALUE
		ANDLW	B'00000011'	;MASK OFF UNWANTED BITS
		MOVWF	PORTE		;UPDATE PORT
		RETURN
;
;
;******************************************************************************
;
;************************* INTERRUPRT SERVICE ROUTINE *************************
;
;******************************************************************************
;
INTSERV		CLRF	INTCON		;STOP INTERRUPTS AND SAVE CONTEXT
		MOVWF	W_TEMP 		;Copy W to TEMP register
		SWAPF	STATUS,W 	;Swap status to be saved into W
		CLRF	STATUS 		;bank 0, regardless of current bank, Clears IRP,RP1,RP0
		MOVWF	STATUS_TEMP 	;Save status to bank zero STATUS_TEMP register
		MOVF	PCLATH,W 	;Only required if using pages 1, 2 and/or 3
		MOVWF	PCLATH_TEMP 	;Save PCLATH into W
		CLRF 	PCLATH 		;Page zero, regardless of current page
;
		BANKSEL	CCPR1L		;READ CAPTURE RESULT
		MOVFW	CCPR1L
		BANKSEL	0
		ANDLW	01FH		;MASK OFF UNSUITABLE BITS
		MOVWF	RERROR		;SAVE CURRENT ERROR VALUE
;
		CLRF	LOOPC		;CLEAR LOOP COUNTER TO RESET TIMING ON GPS PULSE
;
;CHECK IF LOW DC INPUT VOLTS HERE, ABBORT IF VOLTS LOW OR FALLING
;
		MOVF	DCINHV,F
		BTFSC	STATUS,Z	;IF VOLTS LOW THEN ABBORT	
		GOTO	INTDUN
;
		MOVFW	LASTRERROR	;CHECK IF LAST RESULT WAS 0
		BTFSC	STATUS,Z	;AVOID POSIBLE ROLL UNDER ERROR
		GOTO	ROLZERO	
		SUBLW	01FH		;CHECK IF LAST RESULT WAS 01FH
		BTFSC	STATUS,Z	;AVOID POSSIBLE ROLL OVER ERROR
		GOTO	ROLMAX
;
		MOVFW	LASTRERROR
		SUBWF	RERROR,W	;COMPARE RESULTS
		BTFSC	STATUS,Z	;CHECK IF NO CHANGE
		GOTO	ENDERROR
		BTFSS	STATUS,C	;CHECK IF POSITIVE OR NEGATIVE ERROR
		GOTO	ERRORUP
		GOTO	ERRORDN
;
ROLZERO		MOVFW	LASTRERROR	;LAST ERROR WAS ZERO
		SUBWF	RERROR,W	;COMPARE
		BTFSC	STATUS,Z	;CHECK IF NO CHANGE
		GOTO	ENDERROR	
		BTFSC	STATUS,C	;CHECK IF UP OR DOWN REQUIRED	
		GOTO	ERRORDN
		GOTO	ERRORUP
;
ROLMAX		MOVFW	LASTRERROR	;LAST ERROR WAS MAXED (01FH)
		SUBWF	RERROR,W
		BTFSC	STATUS,Z	;CHECK IF NO CHANGE
		GOTO	ENDERROR
		BTFSS	STATUS,C	;CHECK IF UP OR DOWN REQUIRED	
		GOTO	ERRORUP
;
ERRORDN		NOP
		;RRF	NERCOUNT,F	
		;RRF	NERCOUNT,F	;DIVIDE RESULT BY 64 (TOP 2 BITS ARE RELEVANT)
		;RRF	NERCOUNT,F		
		;COMF	NERCOUNT,W
		;ANDLW	003H		;MASK OFF TOP BITS
		;SUBWF	RTUNE,F
		DECF	RTUNE,F		;APPLY CORRECTION
		CLRF	NERCOUNT	;RESET ERROR COUNT		
		MOVLW	LOW ERTUNE
		MOVWF	EEPOINT
		MOVFW	RTUNE
		CALL	EEWRITE		;UPDATE REF TUNE VOLTAGE
		CALL	SETREF		
		GOTO	ENDERROR
;
ERRORUP		NOP
		;RRF	NERCOUNT,F
		;RRF	NERCOUNT,F
		;RRF	NERCOUNT,F	;GET TOP 2 BITS ONLY 
		;COMF	NERCOUNT,W
		;ANDLW	003H
		;ADDWF	RTUNE,F
		INCF	RTUNE,F		;APPLY CORRECTION
		CLRF	NERCOUNT	;RESET ERROR COUNT	
		MOVLW	LOW ERTUNE
		MOVWF	EEPOINT
		MOVFW	RTUNE
		CALL	EEWRITE		;UPDATE REF TUNE VOLTAGE
		CALL	SETREF		
;
ENDERROR	INCF	NERCOUNT,F	;INCREMENT NO ERROR COUNT 
		BTFSC	STATUS,Z	;CHECK IF ROLL OVER TO ZERO
		DECF	NERCOUNT,F	;DON'T ALLOW ROLL OVER OF NO ERROR COUNTER
;
		MOVFW	RERROR
		MOVWF	LASTRERROR	;UPDATE LAST ERROR VALUE
;
		BSF	GFLAG,GPS
;
INTDUN		NOP
		BANKSEL	PIR1		;CLEAR CCP1 INTERRUPT FLAG AND ENABLE INTERRUPTS
		BCF	PIR1,CCP1IF
		BANKSEL	PIE1
		BSF	PIE1,CCP1IE	;ENABLE CCP1 INT
		BANKSEL	0
		BSF	INTCON,PEIE	;ENABLE PERIPHERAL INTERRUPTS
;		
		MOVF	PCLATH_TEMP,W 	;Restore PCLATH
		MOVWF	PCLATH 		;Move W into PCLATH
		SWAPF	STATUS_TEMP,W 	;Swap STATUS_TEMP register into W
		MOVWF	STATUS 		;Move W into STATUS register
		SWAPF	W_TEMP,F 	;Swap W_TEMP
		SWAPF	W_TEMP,W 	;Swap W_TEMP into W
;
		RETFIE			;RETURN FROM INTERRUPT , ALSO ENABLES GIE
;
;
;******************************************************************************
;**************************** GENERAL SUBROUTINES *****************************
;******************************************************************************
;
;
;******************************************************************************
;
;RS232 DATA COMMS ROUTINES
;
;******************************************************************************
;
;PRINT STATUS
;
PRINTSTAT	BTFSC	PORTC,RFMUX	;CHECK IF PLL LOCKED		
		GOTO	STATNORM
		MOVLW	LOW PLLERRT	;PLL ERROR STRING FROM PROGRAM MEMORY
		CALL	PRMEM			
;	
STATNORM	MOVLW	LOW NOERROR	;NO ERROR STRING FROM PROGRAM MEMORY
		CALL	PRMEM
		MOVLW	00DH
		CALL	TXCOMS
		MOVLW	020H
		CALL	TXCOMS
		MOVFW	RERROR
		CALL	PHEX		;SEND STATUS TO RS232
		MOVFW	RTUNE
		CALL	PHEX
		MOVFW	REFHV
		CALL	PHEX
		MOVLW	08H
		CALL	TXCOMS		;BS TO GIVE 2 BYTE PACKED RESULT
		MOVFW	REFLV
		CALL	PHEX
		MOVFW	NERCOUNT
		CALL	PHEX
		MOVFW	VCOHV
		CALL	PHEX
		MOVLW	08H
		CALL	TXCOMS
		MOVFW	VCOLV
		CALL	PHEX
		MOVFW	DCINHV
		CALL	PHEX
		MOVLW	08H
		CALL	TXCOMS
		MOVFW	DCINLV
		CALL	PHEX
		MOVLW	020H
		CALL	TXCOMS
		MOVLW	020H
		CALL	TXCOMS
;
		BTFSC	GFLAG,CURS	;FLASH CURSOR ROUTINE	
		GOTO	CURSOFF
CURSON		BSF	GFLAG,CURS
		MOVLW	03EH		;>
		CALL	TXCOMS
		MOVLW	05FH		;_
		CALL	TXCOMS
		GOTO	CURSEND
;
CURSOFF		BCF	GFLAG,CURS
		MOVLW	020H
		CALL	TXCOMS
		MOVLW	020H
		CALL	TXCOMS
CURSEND		BTFSS	GFLAG,GPS	;CHECK IF GPS IS ACTIVE
		RETURN
		MOVLW	008H
		CALL	TXCOMS
		MOVLW	008H
		CALL	TXCOMS
		MOVLW	008H
		CALL	TXCOMS
		MOVLW	008H
		CALL	TXCOMS
		BCF	GFLAG,GPS		
		MOVLW	047H		;G
		CALL	TXCOMS
		MOVLW	050H		;P
		CALL	TXCOMS
		MOVLW	053H		;S
		CALL	TXCOMS
		RETURN
;
PRBOOT		MOVLW	007H		;PRINT BOOT UP STRING , BELL
		CALL	TXCOMS
		MOVLW	00CH		;FORM FEED
		CALL	TXCOMS
		CALL	PRCRLF
		MOVLW	LOW TXTBOOT	;BOOT STRING FROM PROGRAM MEMORY
		CALL	PRMEM			
		CALL	PRCRLF
		MOVLW	LOW IDENT	;LOAD IDENT ADDRESS FROM EEPROM
		CALL	PREEPROM 	;PRINT
		CALL	PRCRLF
		MOVLW	LOW SERIAL	;LOAD SERIAL # ADDRESS FROM EEPROM	
		CALL	PREEPROM
		CALL	PRCRLF
		CALL	PRCRLF
		MOVLW	LOW DIAGHEAD	;BOOT STRING FROM PROGRAM MEMORY
		CALL	PRMEM
		CALL	PRCRLF
		CALL	PRCRLF
		RETURN				
;
PRCRLF		MOVLW	00DH		;PRINT CR & LF
		CALL	TXCOMS
		MOVLW	00AH
		CALL	TXCOMS
		RETURN
;
;
;** PRINT HEX DATA IN WREG 
;
PHEX		CALL	HEX2ASCII	;CONVERT DATA TO ASCII
		MOVFW	R1	
		CALL	TXCOMS		;SEND FIRST DIGIT
		MOVFW	R0
		CALL	TXCOMS		;SEND SECOND DIGIT
		MOVLW	020H		;PUT IN SPACE
		CALL	TXCOMS		
		CLRWDT
		RETURN
;
;** HEX TO ASCII CONVERTOR , ENTER WITH HEX IN W , EXIT WITH ASCII
;** MSB IN R1 & LSB IN R0
;
HEX2ASCII	CLRWDT
		MOVWF	R1		;SAVE DATA
		ANDLW	00FH		;MASK OFF TOP BITS
		MOVWF	R0
		MOVLW	0AH		;CHECK IF DIGIT OR LETTER
		SUBWF	R0,W
		BTFSC	STATUS,C
		GOTO	HEXASIN			
		MOVLW	030H		;DIGIT SO ADD 30H
		ADDWF	R0,1
		GOTO	ASCNIB
HEXASIN		MOVLW	037H		;LETTER SO ADD 37H
		ADDWF	R0,1
ASCNIB		SWAPF	R1,0
		ANDLW	00FH
		MOVWF	R1
		MOVLW	0AH
		SUBWF	R1,W
		BTFSC	STATUS,C
		GOTO	HEXASIM	
		MOVLW	030H
		ADDWF	R1,1
		RETURN
HEXASIM		MOVLW	037H
		ADDWF	R1,1
		RETURN
;
;** PRINT EEPROM STRING, W CONTAINS START ADDRESS OF STRING, STRING MUST END IN 000H 
;
PREEPROM	MOVWF	R0		;STORE START ADDRESS
PREEPROML	MOVFW	R0
		CALL	READEE
		BTFSC	STATUS,Z	;CHECK IF DATA IS 000H
		RETURN			;RETURN IF DONE
		CALL	TXCOMS		;PRINT CHARACTER
		INCF	R0,F
		GOTO	PREEPROML	;LOOP
;
;** PRINT STRING FROM PROGRAM MEMORY , W CONTAINS START ADDRESS OF STRING OFFSET FROM 0F00H , STRING MUST END IN 000H
;
PRMEM		MOVWF	R0		;STORE START ADDRESS
PRMEML		MOVFW	R0		;
		CALL	READPROG
		BTFSC	STATUS,Z	;CHECK IF FIRST BYTE IS 000H
		RETURN			;RETURN IF DONE
		CALL	TXCOMS
		INCF	R0,F
		GOTO	PRMEML
;
;
;
;** TX DATA ROUTINE ON COMMS PORT , DATA IN W , WAITS TILL PREVIOUS CHARACTER 
;** IS SENT THEN RETURNS.		
;
TXCOMS		NOP
		BANKSEL	TXSTA
		BTFSS	TXSTA,TRMT		
		GOTO	TXCOMS		;WAIT TILL SENT
		BANKSEL	0
		MOVWF	TXREG		;SEND NEW DATA
		CLRWDT
		RETURN		
;
;
;****************************** MEMORY ROUTINES *******************************
;
;READ EEPROM DATA, W CONTAINS ADDRESS ON ENTRY AND DATA ON EXIT
;
READEE		NOP
		BANKSEL	EEADR
		MOVWF 	EEADR 		;Address to read
		BANKSEL	EECON1
		BCF 	EECON1,EEPGD 	;Point to Data memory
		BSF 	EECON1,RD 	;EE Read
		BANKSEL	EEDATA
		MOVF 	EEDATA,W 	;W = EEDATA	
		BANKSEL	0		;BANK0
		RETURN
;
;
;WRITE DATA TO EEPROM , EEPOINT CONTAINS ADDRESS AND W CONTAINS DATA 
;
EEWRITE		NOP
		BANKSEL	EEDATA
		MOVWF	EEDATA		;LOAD DATA
		MOVFW	EEPOINT			
		MOVWF	EEADR		;LOAD ADDRESS LOW BITS
		CLRF	EEADRH		;CLEAR HIGH BITS
		BANKSEL	EECON1
		BCF	EECON1,EEPGD	;POINT TO DATA MEMORY
		BSF	EECON1,WREN	;ENABLE WRITES
		BCF	INTCON,GIE	;DISSABLE INTERRUPTS
		MOVLW	055H
		MOVWF	EECON2
		MOVLW	0AAH
		MOVWF	EECON2
		BSF	EECON1,WR	;REQUIRED SEQUENCE FOR WRITES
		BTFSC	EECON1,WR
		GOTO	$-1		;LOOP TILL WRITE IS COMPLETE
		BCF	EECON1,WREN	;DISABLE WRITES
		BANKSEL	0
		BSF	INTCON,GIE	;RE-ENABLE INTERRUPTS
		RETURN
;
;
;READ PROGRAM MEMORY, W CONTAINS OFFSET FROM 0700H
;ON EXIT W CONTAINS LSB , & GR0 CONTAINS MSB OF LOCATION   
;
READPROG	BSF 	STATUS,RP1	
		BCF 	STATUS,RP0 	; Bank 2
		MOVWF 	EEADR 		; LS Byte of Program Address to read
		MOVLW 	01EH		; STRINGS ALWAYS START AT 1E00H
		MOVWF 	EEADRH 		; MS Byte of Program Address to read
		BSF 	STATUS,RP0	; Bank 3
		BSF 	EECON1,EEPGD 	; Point to PROGRAM memory
		BSF 	EECON1,RD 	; EE Read
;
		NOP			; Any instructions here are ignored as program
		NOP 			; memory is read in second cycle after BSF EECON1,RD
;
		BCF 	STATUS,RP0 	; Bank 2
		MOVF 	EEDATA,W 	; W = LS Byte of Program EEDATA
		BCF	STATUS,RP1	;BACK TO BANK 0
;
		RETURN
;
;************************ TONE AND DELAY SUBROUTINES **************************
;** CW SIDE TONE FREQUENCY
CWTDEL		CLRWDT
		MOVLW	001H
		MOVWF	R3
		MOVLW	003H
		MOVWF	R2
		MOVWF	R1
		CALL	DELAY
		RETURN
;
;** ADC INPUT SETTLE TIME , 1.5MS APPROX
ADCWAIT		CLRWDT
		MOVLW	001H
		MOVWF	R3
		MOVLW	003H
		MOVWF	R2
		MOVWF	R1
		CALL	DELAY
		RETURN
;
;** WAIT SHORT TIME , 100MS APPROX
WAIT		CLRWDT
		MOVLW	001H
		MOVWF	R3
		MOVLW	074H
		MOVWF	R2
		MOVWF	R1
		CALL	DELAY
		RETURN
;
;
;** WAIT 1 SECOND ROUTINE
;
WAITONE		CLRWDT
		MOVLW	005H
		MOVWF	R3
		MOVLW	0CFH
		MOVWF	R2
		MOVWF	R1
		CALL	DELAY
		RETURN
;
;
;
;** CARRIER DELAY ROUTINE
;
CARRIER		CLRWDT
		MOVLW	050H
		MOVWF	R3
		MOVLW	08FH
		MOVWF	R2
		MOVWF	R1
DELAYC		DECFSZ	R1,1     	;ALL FF IS 19 SECONDS
		GOTO 	DELAYC     	
		DECFSZ	R2,1                    
		GOTO	DELAYC
		CLRWDT
		BTFSC	PORTA,KEYIN	
		RETURN			;ABBORT IF KEY LINE GOES HIGH
		BTFSC	PORTD,PTTIN
		RETURN			;ABBORT IF PTT LINE GOES HIGH
		DECFSZ	R3,1      	;MOST SIGNIFICANT REGISTER
       		GOTO	DELAYC
		CLRWDT
		RETURN
;
;
;** DUMB DELAY SUBROUTINE
;
DELAY		DECFSZ	R1,1     	;ALL FF IS 19 SECONDS
		GOTO 	DELAY     	
		DECFSZ	R2,1                    
		GOTO	DELAY
		CLRWDT
		DECFSZ	R3,1      	;MOST SIGNIFICANT REGISTER
       		GOTO	DELAY
		CLRWDT
		RETURN
;
;** DOT BEEP FM
;
DBEEPFM		NOP
		BANKSEL	TRISD
		BCF	TRISD,FSK	;MAKE FSK AND SIDETONE LOW Z OUTPUT
		BCF	TRISD,SIDETONE
		BANKSEL	0
BEPML		MOVLW	038H		;TONE DURATION
        	MOVWF	R3
BEPMD		DECFSZ	R3,F
		GOTO	BEPMHT
		BANKSEL	TRISD
		BSF	TRISD,FSK	;MAKE FSK AND SIDETONE HI Z
		BSF	TRISD,SIDETONE
		BANKSEL	0
        	RETURN
BEPMHT		BSF	PORTD,SIDETONE	;GENERATE AUDIO
		BSF	PORTD,FSK
		MOVLW	0FEH		;FREQ 
		MOVWF	R1		;COUNT REGISTER
BEPMHLH		NOP
		NOP		
		NOP
		DECFSZ	R1,F
		GOTO	BEPMHLH
		BCF	PORTD,SIDETONE
		BCF	PORTD,FSK
		MOVLW	0FEH		;FREQ 
		MOVWF	R1
BEPMHLL		NOP
		NOP
		NOP
		DECFSZ	R1,F
		GOTO	BEPMHLL
		GOTO	BEPMD		;LOOP TILL FINNISHED
;
;** DOT BEEP CW
;
DBEEPCW		NOP
		BANKSEL	TRISD
		BCF	TRISD,SIDETONE	;SIDETONE LOW Z OUTPUT
		BANKSEL	0
CBEPML		MOVLW	038H		;TONE DURATION
        	MOVWF	R3
CBEPMD		DECFSZ	R3,F
		GOTO	CBEPMHT
		BANKSEL	TRISD
		BSF	TRISD,SIDETONE	;MAKE SIDETONE HI Z
		BANKSEL	0
        	RETURN
;
CBEPMHT		BSF	PORTD,SIDETONE	;GENERATE AUDIO
		MOVLW	0FEH		;FREQ 
		MOVWF	R1		;COUNT REGISTER
CBEPMHLH	NOP
		NOP		
		NOP
		DECFSZ	R1,F
		GOTO	CBEPMHLH
		BCF	PORTD,SIDETONE
		MOVLW	0FEH		;FREQ 
		MOVWF	R1
CBEPMHLL	NOP
		NOP
		NOP
		DECFSZ	R1,F
		GOTO	CBEPMHLL
		GOTO	CBEPMD		;LOOP TILL FINNISHED
;
;
;** GENERATE LOW BEEP TO TX TONES (SHORT LOW BEEP)
;
LBEEP  		CALL	WAIT		;SHORT DELAY BEFORE BEEP
		BANKSEL	TRISD
		BCF	TRISD,SIDETONE
		BCF	TRISD,FSK
		BANKSEL	0		;LOW Z SIDETONE AND FSK LINES
		BCF	PORTD,FSK
		BCF	PORTD,SIDETONE	;RESET AUDIO
LBEPML		MOVLW	040H		;TONE DURATION
        	MOVWF	R3
LBEPMD		DECFSZ	R3,F
		GOTO	LBEPMHT
		BANKSEL	TRISD		;HI Z SIDETONE AND FSK LINES
		BSF	TRISD,SIDETONE
		BSF	TRISD,FSK
		BANKSEL	0
        	RETURN
LBEPMHT		BSF	PORTD,SIDETONE	;GENERATE AUDIO
		BSF	PORTD,FSK
		MOVLW	0F0H		;FREQ 
		MOVWF	R1		;COUNT REGISTER
LBEPMHLH	CLRWDT
		NOP
		DECFSZ	R1,F
		GOTO	LBEPMHLH
		BCF	PORTD,SIDETONE
		BCF	PORTD,FSK
		MOVLW	0F0H		;FREQ 
		MOVWF	R1
LBEPMHLL	CLRWDT
		NOP
		DECFSZ	R1,F
		GOTO	LBEPMHLL
		GOTO	LBEPMD		;LOOP TILL FINNISHED
;
;******************************************************************************
;************************ MORSE GENERATION ROUTINES ***************************
;******************************************************************************
;
;** SEND MORSE CODE IDENT STRING
;
MORSEIDENT	MOVLW	LOW IDENTMORSE	;POINT TO START OF IDENT TEXT		
		MOVWF	MORSECH		;STORE START ADDRESS
MREEPROML	MOVFW	MORSECH
		CALL	READEE
		BTFSC	STATUS,Z	;CHECK IF DATA IS 000H
		RETURN			;RETURN IF DONE
		BTFSC	PORTA,KEYIN	
		RETURN			;ABBORT IF KEY LINE GOES HIGH
		BTFSC	PORTD,PTTIN
		RETURN			;ABBORT IF PTT LINE GOES HIGH
		CALL	READMORSE	;LOOK UP MORSE TABLE AND STORE IN DATA REGISTERS
		CALL	TXTMORSE	;SEND MORSE CHARACTER FROM DATA
		CALL	DOTD
		CALL	DOTD		;SPACE BETWEEN CHARACTERS
		INCF	MORSECH,F
		GOTO	MREEPROML	;LOOP
;
;** SEND MORSE CHARACTER FROM LOOKED UP DATA REGISTERS
;
TXTMORSE	BTFSS	MORSE1,7	;LOOK AT FIRST BIT		
		GOTO	CHECKKY
		CALL	DOT		;KEY TX, SEND AUDIO BEEP IF FM
CHECKKY		BTFSC	MORSE1,7		
		GOTO	MORSEDEL
;
;DOT OFF
;
		BCF	PORTD,SIDETONE	;SIDETONE LOW
		CALL	LEDOFF		;PUT LED OFF
		BTFSS	GFLAG,CWON	;CHECK IF DOT WAS CW OR FM
		GOTO	FMDOTFIN
		BCF	GFLAG,CWON	;CLEAR CW ON FLAG
		CALL	SYNTHRX		;END OF CW DOT SO ALWAYS ON RX FREQ HERE
;
FMDOTFIN	CALL	DOTD		;MORSE DOT TIME			
MORSEDEL	MOVLW	B'11000000'	;LOOK AT BIT 7 & 6 ONLY
		ANDWF	MORSE1,W
		BTFSC	STATUS,Z	;CHECK IF FINNISHED
		RETURN			;END IF DONE
		BCF	STATUS,C	;CLEAR CARRY
		RLF	MORSE3,F	;ROTATE DATA TO GET NEXT BIT
		RLF	MORSE2,F
		RLF	MORSE1,F		
		GOTO	TXTMORSE	;LOOP TILL DONE
;
;DOT DELAY
;
DOTD		MOVLW	LOW WPM		;DOT DELAY DURING PAUSES (RX TIME)
		CALL	READEE		;GET WPM DATA HIGH BYTE
		MOVWF	R3
		MOVLW	LOW (WPM+1)	;GET WPM DATA LOW BYTE
		CALL	READEE
		MOVWF	R2
		MOVWF	R1
		CALL	DELAY
		RETURN
;
;DOT ON (SEND)
;
DOT		BTFSC	PORTB,SW1	;CHECK IF CW OR FM MODE	
		GOTO	DOTCW		
;
DOTFM		CALL	LEDRED
		CALL	DBEEPFM		;USE TONE GENERATION ROUTINE
		RETURN
;
DOTCW		BTFSC	GFLAG,CWON
		GOTO	DOTCWON
		BSF	GFLAG,CWON	;SET FLAG TO SHOW CW KEY IS ON
		CALL	SYNTHTX		;TX FREQ TO SEND CW
DOTCWON		CALL	LEDRED
		CALL	DBEEPCW
		RETURN

;
;READ PROGRAM MEMORY CONTAINING MORSE CHARACTER DATA
;W CONTAINS OFFSET FROM MORSE TABLE START EQUAL TO ASCII VALUE
;
READMORSE	MOVWF	R1		;TEMP STORAGE OF START POINTER
		MOVLW	030H
		SUBWF	R1,W		;CONVERT ASCII TO HEX ADDRESS
		MOVWF	R1
		ADDWF	R1,W		;MULTIPLY BY 3 TO GET CORRECT START POINT IN TABLE
		ADDWF	R1,W
		MOVWF	R1
		CALL	READMORL
		MOVWF	MORSE1
		INCF	R1,F
		MOVFW	R1
		CALL	READMORL
		MOVWF	MORSE2
		INCF	R1,F
		MOVFW	R1
		CALL	READMORL
		MOVWF	MORSE3
		RETURN		
;
READMORL	NOP
		BANKSEL	EEADR		; Bank 2
		MOVWF 	EEADR 		; LS Byte of Program Address to read
		MOVLW 	HIGH MORSETAB	; MORSE STRINGS ALWAYS START AT MORSETAB STRING
		MOVWF 	EEADRH 		; MS Byte of Program Address to read
		BANKSEL	EECON1		; Bank 3
		BSF 	EECON1,EEPGD 	; Point to PROGRAM memory
		BSF 	EECON1,RD 	; EE Read
;
		NOP			; Any instructions here are ignored as program
		NOP 			; memory is read in second cycle after BSF EECON1,RD
;
		BANKSEL	EEDATA	 	; Bank 2
		MOVF 	EEDATA,W 	; W = LS Byte of Program EEDATA
		BANKSEL	PORTA		;BACK TO BANK 0
;
		RETURN
;
;******************************************************************************
;**************************** MORSE TABLE *************************************
;******************************************************************************
;
		ORG	00D00H		;START ADDRESS OF MORSE TABLE
;
;3 BYTES PER CHARACTER (24 BITS)
;OFFSET TO ALLOW DIRECT ASCII LOOKUP, IE 0 MORSE = ASCII 030H
;
MORSETAB	DE	B'11101110',B'11101110',B'11100000'	;MORSE 0 = ASCII 30
		DE	B'10111011',B'10111011',B'10000000'	;1
		DE	B'10101110',B'11101110',B'00000000'	;2
		DE	B'10101011',B'11011100',B'00000000'	;3
		DE	B'10101010',B'11100000',B'00000000'	;4
		DE	B'10101010',B'10000000',B'00000000'	;5
		DE	B'11101010',B'10100000',B'00000000'	;6
		DE	B'11101110',B'10101000',B'00000000'	;7
		DE	B'11101110',B'11101010',B'00000000'	;8
		DE	B'11101110',B'11101110',B'10000000'	;9
		DE	B'11101110',B'11101110',B'11100000'	;ASCII 03A
		DE	B'11101110',B'11101110',B'11100000'	;
		DE	B'11101110',B'11101110',B'11100000'	;
		DE	B'11101110',B'11101110',B'11100000'	;
		DE	B'11101110',B'11101110',B'11100000'	;
		DE	B'11101110',B'11101110',B'11100000'	;
		DE	B'11101110',B'11101110',B'11100000'	;ASCII 040H
		DE	B'10111000',B'00000000',B'00000000'	;A = ASCII 041H
		DE	B'11101010',B'10000000',B'00000000'	;B
		DE	B'11101011',B'10100000',B'00000000'	;C
		DE	B'11101010',B'00000000',B'00000000'	;D
		DE	B'10000000',B'00000000',B'00000000'	;E
		DE	B'10101110',B'10000000',B'00000000'	;F
		DE	B'11101110',B'10000000',B'00000000'	;G
		DE	B'10101010',B'00000000',B'00000000'	;H
		DE	B'10100000',B'00000000',B'00000000'	;I
		DE	B'10111011',B'10111000',B'00000000'	;J
		DE	B'11101011',B'10000000',B'00000000'	;K
		DE	B'10111010',B'10000000',B'00000000'	;L
		DE	B'11101110',B'00000000',B'00000000'	;M
		DE	B'11101000',B'00000000',B'00000000'	;N
		DE	B'11101110',B'11100000',B'00000000'	;O
		DE	B'10111011',B'10100000',B'00000000'	;P
		DE	B'11101110',B'10111000',B'00000000'	;Q
		DE	B'10111010',B'00000000',B'00000000'	;R
		DE	B'10101000',B'00000000',B'00000000'	;S
		DE	B'11100000',B'00000000',B'00000000'	;T
		DE	B'10101110',B'00000000',B'00000000'	;U
		DE	B'10101011',B'10000000',B'00000000'	;V
		DE	B'10111011',B'10000000',B'00000000'	;W
		DE	B'11101010',B'11100000',B'00000000'	;X
		DE	B'11101011',B'10111000',B'00000000'	;Y
		DE	B'11101110',B'10100000',B'00000000'	;Z = ASCII 05AH
;
;
;******************************************************************************
;*************************** TEXT STRINGS *************************************
;******************************************************************************
;
		ORG	01E00H	 	;START ADDRESS OF STRINGS MUST HAVE LS BYTE OF 00
;
TXTBOOT		DE	" 122G SYSTEM IS ON-LINE ",000H
;
DIAGHEAD	DE	" ER TU REFV EC VCOV DCIN ",000H
;
PLLERRT		DE	" PLL LOCK ERROR ",00DH,000H
;
NOERROR		DE	"                     ",000H
;
;******************************************************************************
;************************** EEPROM INITIALIZATION *****************************
;******************************************************************************
;
		ORG	2100H		;LOAD EEPROM VALUES FOR SYNTH 
;
;ADF 4153 SYTH FREQUENCY DATA , RIGHT JUSTIFIED , defauls are shown in comments
;R3 SENT FIRST, MSB SENT FIRST
;
SYNTHINIT	DE	000H		;R3 000H LOWEST NOISE & SPUR MODE
		DE	003H		;003H
		DE	083H		;083H
;		
		DE	000H		;R2 000H PFD CURRENT 0.6mA 
		DE	01CH		;01CH	
		DE	0C2H		;0C2H POWER ON
;
		DE	010H		;R1 010H DIVIDER/OPT SELECTION
		DE	072H		;072H
		DE	001H		;001H
; 	
		DE	017H		;R0 02FH 1914.06875 MHz x 64 = 122,500.4 MHz
		DE	0E3H		;0D4H
		DE	02CH		;050H
;
		ORG	2110H		;ALL CHANNEL DATA MUST BE IN THE SAME PAGE
;
;ADF4153 DISSABLE SYNTH FOR RESET
;
SYNTHDIS	DE	000H		;R3 000H LOWEST NOISE & SPUR MODE
		DE	003H		;003H
		DE	083H		;083H
;		
		DE	000H		;R2 000H PFD CURRENT 0.6mA 
		DE	01CH		;01CH	
		DE	0D2H		;0D2H POWER DOWN
;
		DE	010H		;R1 010H DIVIDER/OPT SELECTION
		DE	072H		;072H
		DE	001H		;001H
; 	
		DE	017H		;R0 02FH 1914.0625 MHz x 64 = 122,500.0 MHz
		DE	0E3H		;0D4H
		DE	02CH		;050H
;
		ORG	2120H		;ALL CHANNEL DATA MUST BE IN THE SAME PAGE	
;
;CHANNEL FREQUENCY TABLE
;
FREQ0R		DE	017H		;CH0 SYNTH FREQUENCY DATA RECEIVE (122.356 GHz)(PLL 1911.8125 MHz)
		DE	0DDH		;I.F. = 144.4 MHz
		DE	088H		
RXOPT0		DE	001H		;OPTION BYTE
;
FREQ0T		DE	017H		;CH0 SYNTH FREQUENCY DATA TRANSMIT (122.5004 GHz)(PLL 1914.06875 MHz)
		DE	0E3H		
		DE	02CH
TXOPT0		DE	0F1H		;OPTION BYTE
;
FREQ1R		DE	017H		;CH1 SYNTH FREQUENCY DATA RECEIVE (122.5004 GHz)
		DE	0E3H		;I.F. = 144.4 MHz
		DE	02CH		
RXOPT1		DE	002H		;OPTION BYTE
;
FREQ1T		DE	017H		;CH1 SYNTH FREQUENCY DATA TRANSMIT (122.356 GHz)
		DE	0DDH
		DE	088H
TXOPT1		DE	0F2H		;OPTION BYTE
;
FREQ2R		DE	02FH		;CH2 SYNTH FREQUENCY DATA RECEIVE
		DE	0D2H		
		DE	020H		
RXOPT2		DE	000H		;OPTION BYTE
;
FREQ2T		DE	02FH		;CH2 SYNTH FREQUENCY DATA TRANSMIT
		DE	0D2H
		DE	020H
TXOPT2		DE	000H		;OPTION BYTE
;
FREQ3R		DE	05FH		;CH3 SYNTH FREQUENCY DATA RECEIVE
		DE	092H		
		DE	024H		
RXOPT3		DE	000H		;OPTION BYTE
;
FREQ3T		DE	05FH		;CH3 SYNTH FREQUENCY DATA TRANSMIT
		DE	088H
		DE	0A4H
TXOPT3		DE	000H		;OPTION BYTE
;
FREQ4R		DE	05FH		;CH4 SYNTH FREQUENCY DATA RECEIVE
		DE	0ADH		
		DE	004H		
RXOPT4		DE	000H		;OPTION BYTE
;
FREQ4T		DE	05FH		;CH4 SYNTH FREQUENCY DATA TRANSMIT
		DE	0A8H
		DE	0A4H
TXOPT4		DE	000H		;OPTION BYTE
;
FREQ5R		DE	05FH		;CH5 SYNTH FREQUENCY DATA RECEIVE
		DE	0A4H		
		DE	044H		
RXOPT5		DE	000H		;OPTION BYTE
;
FREQ5T		DE	05FH		;CH5 SYNTH FREQUENCY DATA TRANSMIT
		DE	0A8H
		DE	0A4H
TXOPT5		DE	000H		;OPTION BYTE
;
FREQ6R		DE	05FH		;CH6 SYNTH FREQUENCY DATA RECEIVE
		DE	0AAH		
		DE	050H		
RXOPT6		DE	000H		;OPTION BYTE
;
FREQ6T		DE	05FH		;CH6 SYNTH FREQUENCY DATA TRANSMIT
		DE	0A8H
		DE	0A4H
TXOPT6		DE	000H		;OPTION BYTE
;
FREQ7R		DE	05FH		;CH7 SYNTH FREQUENCY DATA RECEIVE
		DE	0A6H		
		DE	0F8H		
RXOPT7		DE	000H		;OPTION BYTE
;
FREQ7T		DE	05FH		;CH7 SYNTH FREQUENCY DATA TRANSMIT
		DE	0A8H
		DE	0A4H
TXOPT7		DE	000H		;OPTION BYTE
;
FREQ8R		DE	05FH		;CH8 SYNTH FREQUENCY DATA RECEIVE
		DE	0A8H		
		DE	0F4H		
RXOPT8		DE	000H		;OPTION BYTE
;
FREQ8T		DE	05FH		;CH8 SYNTH FREQUENCY DATA TRANSMIT
		DE	0A8H
		DE	0A4H
TXOPT8		DE	000H		;OPTION BYTE
;
FREQ9R		DE	05FH		;CH9 SYNTH FREQUENCY DATA RECEIVE
		DE	0A8H		
		DE	054H		
RXOPT9		DE	000H		;OPTION BYTE
;
FREQ9T		DE	05FH		;CH9 SYNTH FREQUENCY DATA TRANSMIT
		DE	0A8H
		DE	0A4H
TXOPT9		DE	000H		;OPTION BYTE
;
FREQAR		DE	05FH		;CHA SYNTH FREQUENCY DATA RECEIVE
		DE	081H		
		DE	090H		
RXOPTA		DE	000H		;OPTION BYTE
;
FREQAT		DE	05FH		;CHA SYNTH FREQUENCY DATA TRANSMIT
		DE	081H
		DE	090H
TXOPTA		DE	000H		;OPTION BYTE
;
FREQBR		DE	060H		;CHB SYNTH FREQUENCY DATA RECEIVE
		DE	012H		
		DE	0C0H		
RXOPTB		DE	000H		;OPTION BYTE
;
FREQBT		DE	060H		;CHB SYNTH FREQUENCY DATA TRANSMIT
		DE	012H
		DE	0C0H
TXOPTB		DE	000H		;OPTION BYTE
;
FREQCR		DE	000H		;CHC SYNTH FREQUENCY DATA RECEIVE
		DE	008H		
		DE	071H		
RXOPTC		DE	000H		;OPTION BYTE
;
FREQCT		DE	000H		;CHC SYNTH FREQUENCY DATA TRANSMIT
		DE	008H
		DE	0A3H
TXOPTC		DE	000H		;OPTION BYTE
;
FREQDR		DE	000H		;CHD SYNTH FREQUENCY DATA RECEIVE
		DE	008H		
		DE	071H		
RXOPTD		DE	000H		;OPTION BYTE
;
FREQDT		DE	000H		;CHD SYNTH FREQUENCY DATA TRANSMIT
		DE	008H
		DE	0A3H
TXOPTD		DE	000H		;OPTION BYTE
;
FREQER		DE	000H		;CHE SYNTH FREQUENCY DATA RECEIVE
		DE	008H		
		DE	071H		
RXOPTE		DE	000H		;OPTION BYTE
;
FREQET		DE	000H		;CHE SYNTH FREQUENCY DATA TRANSMIT
		DE	008H
		DE	0A3H
TXOPTE		DE	000H		;OPTION BYTE
;
FREQFR		DE	000H		;CHF SYNTH FREQUENCY DATA RECEIVE
		DE	008H		
		DE	071H		
RXOPTF		DE	000H		;OPTION BYTE
;
FREQFT		DE	000H		;CHF SYNTH FREQUENCY DATA TRANSMIT
		DE	008H
		DE	0A3H
TXOPTF		DE	000H		;OPTION BYTE
;
;
;******************************************************************************
;************************** EEPROM OPTION BYTES *******************************
;******************************************************************************
;
		ORG	021A0H		;IDENTITY INFO (020H MAX)
IDENT		DE	" 122G_005 VK3CV / WQ1S ",000H
;
		ORG	021B8H		;SERIAL NUMBER INFO (018H MAX)
SERIAL		DE	" SERIAL # 19F27040005",000H	;YY F MM DD Serial ####
;
		ORG	021D0H			
;
ERTUNE		DE	011H		;(011H NOMINAL) REFERENCE CALIBRATION DATA (10 BITS ARE AVAILABLE, ONLY LOWER 8 USED)
;
ERSTEER		DE	003H		;(003H NOMINAL) REFERANCE STEER LINES STORED DATA (3 BITS ONLY)
;
;
		ORG	21E0H
IDENTMORSE	DE	"VK3CV",000H	;MORSE UNIT IDENT (MUST BE UPPER CASE, 16 CHARACTER MAX)
;
		ORG	021F8H
WPM		DE	001H,0FAH	;MORSE WPM
;
		END	;(BON-E-HOH)

